/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.libjf.config.api.v2.type;

import io.gitlab.jfronny.commons.serialize.databind.api.TypeToken;
import org.jetbrains.annotations.Nullable;

public sealed interface Type {
    public static Type ofClass(java.lang.reflect.Type klazz) {
        Class k;
        if (klazz == Integer.TYPE || klazz == Integer.class) {
            return TInt.INSTANCE;
        }
        if (klazz == Long.TYPE || klazz == Long.class) {
            return TLong.INSTANCE;
        }
        if (klazz == Float.TYPE || klazz == Float.class) {
            return TFloat.INSTANCE;
        }
        if (klazz == Double.TYPE || klazz == Double.class) {
            return TDouble.INSTANCE;
        }
        if (klazz == String.class) {
            return TString.INSTANCE;
        }
        if (klazz == Boolean.TYPE || klazz == Boolean.class) {
            return TBool.INSTANCE;
        }
        if (klazz instanceof Class && (k = (Class)klazz).isEnum()) {
            return new TEnum(k);
        }
        return new TUnknown(klazz, TypeToken.get((java.lang.reflect.Type)klazz));
    }

    public static Type ofToken(TypeToken<?> token) {
        Class k;
        Class klazz = token.getRawType();
        if (klazz == Integer.TYPE || klazz == Integer.class) {
            return TInt.INSTANCE;
        }
        if (klazz == Long.TYPE || klazz == Long.class) {
            return TLong.INSTANCE;
        }
        if (klazz == Float.TYPE || klazz == Float.class) {
            return TFloat.INSTANCE;
        }
        if (klazz == Double.TYPE || klazz == Double.class) {
            return TDouble.INSTANCE;
        }
        if (klazz == String.class) {
            return TString.INSTANCE;
        }
        if (klazz == Boolean.TYPE || klazz == Boolean.class) {
            return TBool.INSTANCE;
        }
        if (klazz instanceof Class && (k = klazz).isEnum()) {
            return new TEnum(k);
        }
        return new TUnknown(klazz, token);
    }

    @Deprecated(forRemoval=true)
    default public boolean isInt() {
        return this instanceof TInt;
    }

    @Deprecated(forRemoval=true)
    default public boolean isLong() {
        return this instanceof TLong;
    }

    @Deprecated(forRemoval=true)
    default public boolean isFloat() {
        return this instanceof TFloat;
    }

    @Deprecated(forRemoval=true)
    default public boolean isDouble() {
        return this instanceof TDouble;
    }

    @Deprecated(forRemoval=true)
    default public boolean isString() {
        return this instanceof TString;
    }

    @Deprecated(forRemoval=true)
    default public boolean isBool() {
        return this instanceof TBool;
    }

    @Deprecated(forRemoval=true)
    default public boolean isEnum() {
        return this instanceof TEnum;
    }

    @Deprecated(forRemoval=true)
    default public <T> TEnum<T> asEnum() {
        Type type = this;
        if (type instanceof TEnum) {
            TEnum c = (TEnum)type;
            return c;
        }
        throw new ClassCastException("This type is not an enum");
    }

    @Nullable
    public java.lang.reflect.Type asClass();

    @Nullable
    default public TypeToken<?> asToken() {
        java.lang.reflect.Type type = this.asClass();
        return type == null ? null : TypeToken.get((java.lang.reflect.Type)type);
    }

    public String getName();

    public static final class TInt
    implements Type {
        public static TInt INSTANCE = new TInt();

        private TInt() {
        }

        @Override
        public Class<Integer> asClass() {
            return Integer.class;
        }

        @Override
        public String getName() {
            return "Integer";
        }
    }

    public static final class TLong
    implements Type {
        public static TLong INSTANCE = new TLong();

        private TLong() {
        }

        @Override
        public Class<Long> asClass() {
            return Long.class;
        }

        @Override
        public String getName() {
            return "Long";
        }
    }

    public static final class TFloat
    implements Type {
        public static TFloat INSTANCE = new TFloat();

        private TFloat() {
        }

        @Override
        public Class<Float> asClass() {
            return Float.class;
        }

        @Override
        public String getName() {
            return "Float";
        }
    }

    public static final class TDouble
    implements Type {
        public static TDouble INSTANCE = new TDouble();

        private TDouble() {
        }

        @Override
        public Class<Double> asClass() {
            return Double.class;
        }

        @Override
        public String getName() {
            return "Double";
        }
    }

    public static final class TString
    implements Type {
        public static TString INSTANCE = new TString();

        private TString() {
        }

        @Override
        public Class<String> asClass() {
            return String.class;
        }

        @Override
        public String getName() {
            return "String";
        }
    }

    public static final class TBool
    implements Type {
        public static TBool INSTANCE = new TBool();

        private TBool() {
        }

        @Override
        public Class<Boolean> asClass() {
            return Boolean.class;
        }

        @Override
        public String getName() {
            return "Boolean";
        }
    }

    public record TEnum<T>(@Nullable Class<T> klazz, TypeToken<T> token, String name, T[] options) implements Type
    {
        public TEnum(Class<T> klazz) {
            this(klazz, TypeToken.get(klazz), klazz.getSimpleName(), klazz.getEnumConstants());
        }

        public static TEnum<String> create(String name, String[] options) {
            return new TEnum<String>(null, null, name, options);
        }

        @Override
        public Class<T> asClass() {
            return this.klazz;
        }

        @Override
        @Nullable
        public TypeToken<?> asToken() {
            return this.token;
        }

        @Override
        public String getName() {
            return this.name;
        }

        public T optionForString(String string) {
            for (T option : this.options) {
                if (!option.toString().equals(string)) continue;
                return option;
            }
            return null;
        }
    }

    public record TUnknown(java.lang.reflect.Type klazz, TypeToken<?> token) implements Type
    {
        @Override
        @Nullable
        public java.lang.reflect.Type asClass() {
            return this.klazz;
        }

        @Override
        @Nullable
        public TypeToken<?> asToken() {
            return this.token;
        }

        @Override
        public String getName() {
            String string;
            java.lang.reflect.Type type = this.klazz;
            if (type instanceof Class) {
                Class k = (Class)type;
                string = k.getSimpleName();
            } else {
                string = this.klazz.getTypeName();
            }
            return string;
        }
    }
}

